@echo off
setlocal enabledelayedexpansion

:: ========================
:: CONFIGURATION SECTION
:: ========================
set "CID=5B3EE0F551004B2791EE5241F675B235-6B"
set "INSTALL_DIR=C:\CrowdStrike"
set "LOG_FILE=%TEMP%\CrowdStrike_Install.log"
set "EXACT_SOPHOS_LOC=C:\Program Files\Sophos\Sophos Endpoint Agent\SophosUninstall.exe"
set "ALT_SOPHOS_LOC=C:\Crowdstrike\SophosUninstall.exe"

:: Hardcoded location information (using first location as example)
set "SELECTED_GROUP=Canada - International_ON"
set "SELECTED_TOKEN=6541EE65"
set "GROUP_TAG=International"

:: ========================
:: INITIALIZATION
:: ========================
title Sophos Uninstall & CrowdStrike Install Tool
echo [%date% %time%] Script started for %SELECTED_GROUP% >> "%LOG_FILE%"

:: Verify administrator privileges
net session >nul 2>&1
if %ERRORLEVEL% neq 0 (
    echo ERROR: This script must be run as Administrator.
    echo [%date% %time%] ERROR: Admin rights required >> "%LOG_FILE%"
    pause
    exit /b 1
)

:: Create installation directory
if not exist "%INSTALL_DIR%" (
    mkdir "%INSTALL_DIR%" 2>nul || (
        echo ERROR: Could not create %INSTALL_DIR%
        echo [%date% %time%] ERROR: Directory creation failed >> "%LOG_FILE%"
        pause
        exit /b 1
    )
)

:: ========================
:: FILE DOWNLOADS
:: ========================
set "CS_INSTALL=%INSTALL_DIR%\CSInstall.exe"
set "SOPHOS_REMOVER=%INSTALL_DIR%\SophosUninstall.exe"
set "SOPHOS_ZAP=%INSTALL_DIR%\SophosZap.exe"

:: Download CrowdStrike installer with retry logic
if not exist "%CS_INSTALL%" (
    echo Downloading CrowdStrike installer...
    set "download_success=0"
    for /l %%i in (1,1,3) do if !download_success! equ 0 (
        powershell -Command "Invoke-WebRequest -Uri 'https://crowdstrike.coreslab.com/downloads/CSInstall.exe' -OutFile '%CS_INSTALL%' -ErrorAction Stop" && set "download_success=1"
        if !download_success! equ 0 (
            echo [%date% %time%] Download attempt %%i failed >> "%LOG_FILE%"
            timeout /t 5 >nul
        )
    )
    if not exist "%CS_INSTALL%" (
        echo ERROR: Could not download CSInstall.exe after 3 attempts
        echo [%date% %time%] ERROR: CSInstall.exe download failed >> "%LOG_FILE%"
        pause
        exit /b 1
    )
    echo [%date% %time%] CSInstall.exe downloaded successfully >> "%LOG_FILE%"
)

:: Download Sophos removal tools if needed
if not exist "%SOPHOS_REMOVER%" (
    echo Downloading Sophos Uninstaller...
    powershell -Command "Invoke-WebRequest -Uri 'https://crowdstrike.coreslab.com/downloads/SophosUninstall.exe' -OutFile '%SOPHOS_REMOVER%'" || (
        echo WARNING: Could not download SophosUninstall.exe
        echo [%date% %time%] WARNING: SophosUninstall.exe download failed >> "%LOG_FILE%"
    )
)

if not exist "%SOPHOS_ZAP%" (
    echo Downloading Sophos Zap tool...
    powershell -Command "Invoke-WebRequest -Uri 'https://crowdstrike.coreslab.com/downloads/SophosZap.exe' -OutFile '%SOPHOS_ZAP%'" || (
        echo WARNING: Could not download SophosZap.exe
        echo [%date% %time%] WARNING: SophosZap.exe download failed >> "%LOG_FILE%"
    )
)

:: ========================
:: SOPHOS REMOVAL PROCESS
:: ========================
echo.
echo ==========================================
echo BEGINNING SOPHOS UNINSTALLATION PROCESS
echo This may take up to 5 minutes to complete
echo Please wait and do not close this window...
echo ==========================================
echo.

:: Try built-in Sophos uninstaller first
if exist "%EXACT_SOPHOS_LOC%" (
    echo [%date% %time%] Using built-in Sophos uninstaller >> "%LOG_FILE%"
    echo Found Sophos uninstaller at default location
    start "" /wait "%EXACT_SOPHOS_LOC%" --quiet
    goto :sophos_removal_complete
)

:: Try alternate location if default not found
if exist "%ALT_SOPHOS_LOC%" (
    echo [%date% %time%] Using alternate Sophos uninstaller >> "%LOG_FILE%"
    echo Found Sophos uninstaller at alternate location
    start "" /wait "%ALT_SOPHOS_LOC%" --quiet
    goto :sophos_removal_complete
)

:: Fallback to downloaded remover if available
if exist "%SOPHOS_REMOVER%" (
    echo [%date% %time%] Using downloaded Sophos uninstaller >> "%LOG_FILE%"
    echo Using downloaded Sophos removal tool
    start "" /wait "%SOPHOS_REMOVER%" --quiet
    goto :sophos_removal_complete
)

echo WARNING: No Sophos uninstaller found in any location
echo [%date% %time%] WARNING: Sophos uninstaller not found >> "%LOG_FILE%"

:sophos_removal_complete
echo [%date% %time%] Sophos removal process completed >> "%LOG_FILE%"
echo Sophos removal process completed

:: ========================
:: CROWDSTRIKE INSTALLATION
:: ========================
echo.
echo ============================================
echo PREPARING TO INSTALL CROWDSTRIKE SENSOR
echo This process will take 5-10 minutes to complete
echo DO NOT CLOSE THIS WINDOW DURING INSTALLATION
echo ============================================
echo.

echo Installing CrowdStrike for: %SELECTED_GROUP%
echo Using Provisioning Token: %SELECTED_TOKEN%
echo Using Group Tag: %GROUP_TAG%
echo [%date% %time%] Installing for %SELECTED_GROUP% >> "%LOG_FILE%"

:: Install CrowdStrike with GroupingTags
echo Starting CrowdStrike installation... (Please be patient)
"%CS_INSTALL%" /install /quiet /norestart CID="%CID%" ProvToken="%SELECTED_TOKEN%" ProvNoWait=1 GroupingTags="%GROUP_TAG%"
set "INSTALL_RESULT=%ERRORLEVEL%"

if %INSTALL_RESULT% neq 0 (
    echo ERROR: Installation failed with code %INSTALL_RESULT%
    echo [%date% %time%] ERROR: Installation failed with code %INSTALL_RESULT% >> "%LOG_FILE%"
    pause
    exit /b %INSTALL_RESULT%
)

:: Set grouping tags
echo Configuring group tags...
if exist "C:\Program Files\CrowdStrike\CSSensorSettings.exe" (
    "C:\Program Files\CrowdStrike\CSSensorSettings.exe" set --grouping-tags "%GROUP_TAG%"
) else if exist "C:\Program Files (x86)\CrowdStrike\CSSensorSettings.exe" (
    "C:\Program Files (x86)\CrowdStrike\CSSensorSettings.exe" set --grouping-tags "%GROUP_TAG%"
) else (
    echo WARNING: Could not set grouping tags - CSSensorSettings.exe not found
    echo [%date% %time%] WARNING: Could not set grouping tags >> "%LOG_FILE%"
)

:: ========================
:: COMPLETION
:: ========================
echo [%date% %time%] Installation completed successfully >> "%LOG_FILE%"
echo.
echo ============================================
echo INSTALLATION COMPLETED SUCCESSFULLY
echo Group Tag: %GROUP_TAG%
echo Location: %SELECTED_GROUP%
echo ============================================
echo.
pause
exit /b 0